macroScript bitmapMan category:"Test"
(
	global bitmapArr
	fn initInterface = ()
	fn checkCharacters chckStr =
	(
		local allowedChr = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_#"
		local removeMask = #{1..chckStr.count}
		local newstr = ""
		for i=1 to chckStr.count do for j=1 to allowedChr.count do if chckStr[i] == allowedChr[j] do removeMask[i] = false
		for i=1 to chckStr.count do if not removeMask[i] do newStr += chckStr[i]
		newStr
	)
	rollout bitmapSelector "Scene bitmaps"
	(
		multiListBox bitmapList items:#() height:40 across:2
		multiListBox pathList items:#() height:40
		on pathList selected val do
		(
			bitmaplist.selection = pathlist.selection
			initInterface()
		)
		on bitmapList selected val do
		(
			pathlist.selection = bitmaplist.selection
			initInterface()
		)
	)
	rollout bitmapManRoll "Bitmap Texture Manager v 0.1"
	(
		label fNameLab "Filename:" across:3 align:#left offset:[0,20]
		editText fnameText "" align:#left offset:[-83,20] width:120
		button setName "Set" align:#left offset:[-130,20]
		label fNamePrefixLab "Set filename prefix:" across:3 align:#left
		editText fnamePrefixText "" text:"prefix_" align:#left offset:[-83,0] width:120
		button setPrefix "Set" align:#left offset:[-130,0]
		label fNameSuffixLab "Set filename suffix:" across:3 align:#left
		editText fnameSuffixText "" text:"_suffix" align:#left offset:[-83,0] width:120
		button setSuffix "Set" align:#left offset:[-130,0]
		label renPatternLab "Rename pattern:" across:2 offset:[185,-78]
		editText renPatternText "" text:"filename_####" offset:[95,-78] width:120
		spinner startNum "Start:" type:#integer range:[0,99999999999,0] width:80 offset:[13,0]
		button batchButton "Rename"	offset:[125,0]
		label dirLab "Set directory:" across:3 align:#left offset:[1,42]
		button dirButton "" align:#left offset:[-100,38]
		button folderButton "Open folder" align:#left offset:[-190,38]
		radiobuttons dirAction "" labels:#("Copy","Move") align:#left
		label extLab "Set filename extension:" across:2 offset:[211,-50]
		dropdownList extensionList items:#("jpg","png","tga") width:70 offset:[35,-30] across:2
		button extbutton "Set" offset:[125,-27]
		groupBox renamebox "Rename options:" pos:[5,5] width:270 height:100
		groupBox batchBox "Batch rename:" pos:[280,5] width:270 height:100
		groupBox optBox "Directory:" pos:[5,110] width:270 height:70
		groupBox extBox "File extension:" pos:[280,110] width:270 height:70
		label selLab "1 texture bitmap selected"
		subrollout bitmapSelectorSub "Scene bitmaps" height:320
		on extbutton pressed do
		(
			tmpArr = bitmapSelector.bitmapList.items
			cSelect = bitmapSelector.bitmapList.selection as array
			newExt = extensionList.items[extensionList.selection]
			for i=1 to cSelect.count do
			(
				oldName = tmpArr[cSelect[i]]
				splitName = filterstring oldName "."
				if toLower(splitname[2]) != newExt do
				(
					tmpBitmap = copy bitmapArr[cSelect[i]].bitmap
					tmpArr[cSelect[i]] = splitName[1] + "." + newext
					bitmapArr[cSelect[i]].filename = ""
					tmpBitmap.filename = bitmapSelector.pathList.items[cSelect[i]] + tmpArr[cSelect[i]]
					save tmpBitmap
					bitmapArr[cSelect[i]].filename = bitmapSelector.pathList.items[cSelect[i]] + tmpArr[cSelect[i]]
					bitmapArr[i].reload()
					deleteFile(bitmapSelector.pathList.items[cSelect[i]] + oldName)
				)
			)
			bitmapSelector.bitmapList.items = tmpArr
		)
		on folderButton pressed do
		(
			cNum = (bitmapSelector.bitmapList.selection as array)[1]
			cFolder = bitmapSelector.pathList.items[cNum]
			ShellLaunch ("\""+ cFolder + "\"") ""
		)
		on setName pressed do
		(
			tmpArr = bitmapSelector.bitmapList.items
			cNum = (bitmapSelector.bitmapList.selection as array)[1]
			cName = tmpArr[cNum]
			splitName = filterstring cName "."
			tmpArr[cNum] = fnameText.text + "." + splitName[2]
			bitmapSelector.bitmapList.items = tmpArr
			oldName = bitmapArr[cNum].filename
			bitmapArr[cNum].filename = ""
			renameFile oldName (bitmapSelector.pathList.items[cNum] + tmpArr[cNum])
			bitmapArr[cNum].filename = (bitmapSelector.pathList.items[cNum] + tmpArr[cNum])
			bitmapArr[cNum].reload()
		)
		on setPrefix pressed do
		(
			tmpArr = bitmapSelector.bitmapList.items
			cSelect = bitmapSelector.bitmapList.selection
			for i in cSelect do
			(
				oldName = tmpArr[i]
				tmpArr[i] = fnamePrefixText.text + tmpArr[i]
				bitmapArr[i].filename = ""
				renameFile (bitmapSelector.pathList.items[i] + oldName) (bitmapSelector.pathList.items[i] + tmpArr[i])
				bitmapArr[i].filename = bitmapSelector.pathList.items[i] + tmpArr[i]
				bitmapArr[i].reload()
			)
			bitmapSelector.bitmapList.items = tmpArr
		)
		on setSuffix pressed do
		(
			tmpArr = bitmapSelector.bitmapList.items
			cSelect = bitmapSelector.bitmapList.selection
			for i in cSelect do
			(
				oldName = tmpArr[i]
				splitName = filterstring oldName "."
				tmpArr[i] = splitName[1] + fnameSuffixText.text + "." + splitName[2]
				bitmapArr[i].filename = ""
				renameFile (bitmapSelector.pathList.items[i] + oldName) (bitmapSelector.pathList.items[i] + tmpArr[i])
				bitmapArr[i].filename = bitmapSelector.pathList.items[i] + tmpArr[i]
				bitmapArr[i].reload()
			)
			bitmapSelector.bitmapList.items = tmpArr
		)
		on batchButton pressed do
		(
			pat = renPatternText.text
			ns = findString pat "#"
			nc = 0
			for i=1 to pat.count do if pat[i] == "#" do nc += 1
			tmpArr = bitmapSelector.bitmapList.items
			cSelect = bitmapSelector.bitmapList.selection as array
			for i=1 to cSelect.count do
			(
				oldName = tmpArr[cSelect[i]]
				splitName = filterstring oldName "."
				ft = "0" + (nc as string) + "u"
				fi = formattedPrint (i-1+startNum.value) format:ft
				tmpArr[cSelect[i]] = (replace pat ns nc fi) + "." + splitName[2]
				bitmapArr[cSelect[i]].filename = ""
				renameFile (bitmapSelector.pathList.items[cSelect[i]] + oldName) (bitmapSelector.pathList.items[cSelect[i]] + tmpArr[cSelect[i]])
				bitmapArr[cSelect[i]].filename = bitmapSelector.pathList.items[cSelect[i]] + tmpArr[cSelect[i]]
				bitmapArr[cSelect[i]].reload()
			)
			bitmapSelector.bitmapList.items = tmpArr
		)
		on renPatternText changed val do
		(
			renPatternText.text = checkCharacters val
		)
		on fnameSuffixText changed val do
		(
			fnameSuffixText.text = checkCharacters val
		)
		on fnamePrefixText changed val do
		(
			fnamePrefixText.text = checkCharacters val
		)
		on fnameText changed val do
		(
			fnameText.text = checkCharacters val
		)
		on dirButton pressed do
		(
			initDir = bitmapselector.pathList.items[(bitmapselector.pathList.selection as array)[1]]
			newPath = getSavePath initialDir:initDir
			if newpath != undefined do
			(
				selectedItems = bitmapSelector.bitmapList.selection
				pathItems = bitmapSelector.pathList.items
				for i=1 to bitmapArr.count do
				(
					if selectedItems[i] do
					(
						oldLoc = bitmapSelector.pathList.items[i] + bitmapSelector.bitmapList.items[i]
						copyFile oldLoc (newpath + "\\" + bitmapSelector.bitmapList.items[i])
						pathItems[i] = newpath + "\\"
						bitmapArr[i].filename = newpath + "\\" + bitmapSelector.bitmapList.items[i]
						bitmapArr[i].reload()
						if dirAction.state == 2 do deleteFile oldLoc
					)
				)
				bitmapSelector.pathList.items = pathItems
			)
		)
	)
	fn initInterface = 
	(
		singleItem = (bitmapSelector.bitmaplist.selection as array).count == 1
		if singleItem
		then
		(
			tmpStr = filterstring bitmapSelector.bitmaplist.items[(bitmapSelector.bitmaplist.selection as array)[1]] "."
 			bitmapManRoll.fnameText.text = tmpStr[1]
			bitmapManRoll.fnameText.enabled = true
			bitmapManRoll.fNameLab.enabled = true
			bitmapManRoll.setName.enabled = true
			bitmapManRoll.fNamePrefixLab.enabled = false
			bitmapManRoll.fnamePrefixText.enabled = false
			bitmapManRoll.setPrefix.enabled = false
			bitmapManRoll.fNameSuffixLab.enabled = false
			bitmapManRoll.fnameSuffixText.enabled = false
			bitmapManRoll.setSuffix.enabled = false
			bitmapManRoll.renPatternLab.enabled = false
			bitmapManRoll.renPatternText.enabled = false
			bitmapManRoll.startNum.enabled = false
			bitmapManRoll.batchButton.enabled = false
			bitmapManRoll.folderButton.enabled = true
			bitmapManRoll.selLab.text = "1 texture bitmap selected"
		)
		else
		(
			bitmapManRoll.fnameText.text = ""
			bitmapManRoll.fnameText.enabled = false
			bitmapManRoll.fNameLab.enabled = false
			bitmapManRoll.setName.enabled = false
			bitmapManRoll.fNamePrefixLab.enabled = true
			bitmapManRoll.fnamePrefixText.enabled = true
			bitmapManRoll.setPrefix.enabled = true
			bitmapManRoll.fNameSuffixLab.enabled = true
			bitmapManRoll.fnameSuffixText.enabled = true
			bitmapManRoll.setSuffix.enabled = true
			bitmapManRoll.renPatternLab.enabled = true
			bitmapManRoll.renPatternText.enabled = true
			bitmapManRoll.startNum.enabled = true
			bitmapManRoll.batchButton.enabled = true
			bitmapManRoll.folderButton.enabled = false
			bitmapManRoll.selLab.text = (((bitmapSelector.bitmaplist.selection as array).count) as string) + " texture bitmaps selected"
		)
	)
 	fn collectBitmaps =
 	(
 		bitmapArr = getClassInstances bitmaptexture
 		tmpArr = #()
 		nameArr = #()
 		pathArr = #()
 		for i in bitmapArr do append tmpArr i.filename
 		for i in tmpArr do
 		(
 			tarr = filterString i "\\"
 			append nameArr tarr[tarr.count]
 			append pathArr (replace i (findString i tarr[tarr.count]) tarr[tarr.count].count "")
 		)
 		bitmapSelector.bitmaplist.items = nameArr
 		bitmapSelector.pathlist.items = pathArr
 		if bitmapArr.count == 0
 		then
 		(
 			destroyDialog bitmapManRoll
 			messageBox "Scene does not contain any bitmapTexture instances"
 		)
 		else
 		(
 			bitmapSelector.bitmaplist.selection = #{1}
 			bitmapSelector.pathlist.selection = #{1}
 		)
	)
	createDialog bitmapManRoll width:555
	addSubRollout bitmapManRoll.bitmapSelectorSub bitmapselector
	collectBitmaps()
	initInterface()
)